<?php
if (!defined('_GNUBOARD_')) exit;

/*************************************************************************
**
**  sms5에 사용할 함수 모음
**
*************************************************************************/

// 한페이지에 보여줄 행, 현재페이지, 총페이지수, URL
function sms5_sub_paging($write_pages, $cur_page, $total_page, $url, $add="", $starget="")
{
    if( $starget ){
        $url = preg_replace('#&amp;'.$starget.'=[0-9]*#', '', $url) . '&amp;'.$starget.'=';
    }

    $str = '';
    if ($cur_page > 1) {
        $str .= '<a href="'.$url.'1'.$add.'" class="pg_page pg_start">처음</a>'.PHP_EOL;
    }

    $start_page = ( ( (int)( ($cur_page - 1 ) / $write_pages ) ) * $write_pages ) + 1;
    $end_page = $start_page + $write_pages - 1;

    if ($end_page >= $total_page) $end_page = $total_page;

    if ($start_page > 1) $str .= '<a href="'.$url.($start_page-1).$add.'" class="pg_page pg_prev">이전</a>'.PHP_EOL;

    if ($total_page > 1) {
        for ($k=$start_page;$k<=$end_page;$k++) {
            if ($cur_page != $k)
                $str .= '<a href="'.$url.$k.$add.'" class="pg_page">'.$k.'<span class="sound_only">페이지</span></a>'.PHP_EOL;
            else
                $str .= '<span class="sound_only">열린</span><strong class="pg_current">'.$k.'</strong><span class="sound_only">페이지</span>'.PHP_EOL;
        }
    }

    if ($total_page > $end_page) $str .= '<a href="'.$url.($end_page+1).$add.'" class="pg_page pg_next">다음</a>'.PHP_EOL;

    if ($cur_page < $total_page) {
        $str .= '<a href="'.$url.$total_page.$add.'" class="pg_page pg_end">맨끝</a>'.PHP_EOL;
    }

    if ($str)
        return "<nav class=\"pg_wrap\"><span class=\"pg\">{$str}</span></nav>";
    else
        return "";
}

// 권한 검사
function ajax_auth_check($auth, $attr)
{
    global $is_admin;

    if ($is_admin == 'super') return;

    if (!trim($auth))
        die("{\"error\":\"이 메뉴에는 접근 권한이 없습니다.\\n\\n접근 권한은 최고관리자만 부여할 수 있습니다.\"}");

    $attr = strtolower($attr);

    if (!strstr($auth, $attr)) {
        if ($attr == 'r')
            die("{\"error\":\"읽을 권한이 없습니다.\"}");
        else if ($attr == 'w')
            die("{\"error\":\"입력, 추가, 생성, 수정 권한이 없습니다.\"}");
        else if ($attr == 'd')
            die("{\"error\":\"삭제 권한이 없습니다.\"}");
        else
            die("{\"error\":\"속성이 잘못 되었습니다.\"}");
    }
}

if ( ! function_exists('array_overlap')) {
    function array_overlap($arr, $val) {
        for ($i=0, $m=count($arr); $i<$m; $i++) {
            if ($arr[$i] == $val)
                return true;
        }
        return false;
    }
}
if ( ! function_exists('get_hp')) {
    function get_hp($hp, $hyphen=1)
    {
        global $g5;

        if (!is_hp($hp)) return '';

        if ($hyphen) $preg = "$1-$2-$3"; else $preg = "$1$2$3";

        $hp = str_replace('-', '', trim($hp));
        $hp = preg_replace("/^(01[016789])([0-9]{3,4})([0-9]{4})$/", $preg, $hp);

        if ($g5['sms5_demo'])
            $hp = '0100000000';

        return $hp;
    }
}
if ( ! function_exists('is_hp')) {
    function is_hp($hp)
    {
        $hp = str_replace('-', '', trim($hp));
        if (preg_match("/^(01[016789])([0-9]{3,4})([0-9]{4})$/", $hp))
            return true;
        else
            return false;
    }
}
if ( ! function_exists('alert_just')) {
    // 경고메세지를 경고창으로
    function alert_just($msg='', $url='')
    {
        global $g5;

        if (!$msg) $msg = '올바른 방법으로 이용해 주십시오.';

        //header("Content-Type: text/html; charset=$g5[charset]");
        echo "<meta charset=\"utf-8\">";
        echo "<script language='javascript'>alert('$msg');";
        echo "</script>";
        exit;
    }
}

if ( ! function_exists('utf2euc')) {
    function utf2euc($str) {
        return iconv("UTF-8","cp949//IGNORE", $str);
    }
}
if ( ! function_exists('is_ie')) {
    function is_ie() {
        return isset($_SERVER['HTTP_USER_AGENT']) && (strpos($_SERVER['HTTP_USER_AGENT'], 'Trident') !== false || strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false);
    }
}

//	바이트길이
function strByte($char){
	$word_length=strlen($char);
	for($i = 0;$i<$word_length;$i++) {
		if(ord(substr($char,$i,1)) > 0xa1 && ord(substr($char,$i,1)) <= 0xfe) {// 한글코드( 2byte )경우
			$Hstr++;
		}else{// 한글이 아닌 영문,숫자등의 1byte문자
			$Estr++;
		}
	}
	return ($Hstr + $Estr);
}

/**
 * SMS 발송을 관장하는 메인 클래스이다.
 *
 * 접속, 발송, URL발송, 결과등의 실질적으로 쓰이는 모든 부분이 포함되어 있다.
 */

class SMSi {

	var $Data = array();
	var $Result = array();

	// 접속을 위해 사용하는 변수를 정리한다.
	function SMS_Con($host, $id, $pw) {
		$this->socket_host	= $host;
		$this->socket_port	= 3453;
		$this->smsi_id = AddSpace($id, 15);
		$this->smsi_pw = md5($pw);
	}

	function Add($sType, $strToCall, $strCallBack, $strMsg, $strMsgSub="", $strDate="", $mmslist="") {

		$strMsg = iconv_euckr($strMsg);
		$strMsgSub = iconv_euckr($strMsgSub);

		$sType = trim($sType);
//		$strToCall = trim($strToCall);
		$strCallBack = preg_replace("/[^0-9]/i", "", trim($strCallBack));
		$strDate = preg_replace("/[^0-9]/i", "", trim($strDate));
		$strMsg = str_replace("\r\n", "\n", rtrim($strMsg));
		$strMsgSub = trim($strMsgSub);

		if ($sType == 'S') $msgLen = 90;
		else if ($sType == 'L' || $sType == 'M') $msgLen = 2000;
		else { echo "ERROR : \$sType값이 올바르지 않습니다."; return false; }

//		$strToCall = explode(";", $strToCall);
		$CallCount = count($strToCall);
//		if ($CallCount == 1) $strToCall = array($strToCall);
		if (!is_array($strToCall)) $strToCall = array($strToCall);

		$error_hp = CheckPhone($strToCall, $CallCount);
		if ($error_hp) { echo $error_hp; return false; }
		$error_callback = CheckCallBack($strCallBack);
		if ($error_callback) { echo $error_callback; return false; }
		$error_reqdate = CheckReqDate($strDate);
		if ($error_reqdate) { echo $error_reqdate; return false; }
		if (!$strMsg) { echo "ERROR : 문자내용이 없습니다."; return false; }

		if ($strDate) $strDate = substr($strDate, 0, 4)."-".substr($strDate, 4, 2)."-".substr($strDate, 6, 2)." ".substr($strDate, 8, 2).":".substr($strDate, 10, 2);
		$strCallBack = AddSpace($strCallBack,11);
		$strDate = AddSpace($strDate,16);

		$strMms_Txt = "";
		if ($mmslist) {
			$mmslist_arr = explode(",", $mmslist);
			$strMms_Txt = ($mmslist_arr[0]) ? $mmslist_arr[0] : AddSpace("", 8);
			$strMms_Txt .= ($mmslist_arr[1]) ? $mmslist_arr[1] : AddSpace("", 14);
			$strMms_Txt .= ($mmslist_arr[2]) ? $mmslist_arr[2] : AddSpace("", 14);
		}

		$strMsgSub = str_replace("\r\n", " ", $strMsgSub);
		$strMsgSub = str_replace("<", "[", $strMsgSub);
		$strMsgSub = str_replace(">", "]", $strMsgSub);

		$strMsgSub = AddSpace(CutChar($strMsgSub, 20), 20);
		$strMsg = AddSpace(CutChar($strMsg, $msgLen), $msgLen);

		$j = count($this->Data);
//		for ($i=0; $i<($CallCount+$j); $i++) {
		for ($i=0; $i<$CallCount; $i++) {
			if ($strToCall[$i]) {
				if (substr($strToCall[$i], 0, 3) == '050') $strToCall[$i] = substr($strToCall[$i], 1);
				$strToCall[$i] = AddSpace(preg_replace("/[^0-9]/i","",$strToCall[$i]),11);
				$this->Data[$j] = $sType.$strToCall[$i].$strCallBack.$strDate.$strMsg.$strMsgSub.$strMms_Txt;
				$j++;
			}
		}
		return true;
	}

	function Send() {
		$fsocket = @fsockopen($this->socket_host,$this->socket_port, $errno, $errstr, 10);
		if (!$fsocket) {
			set_time_limit(30);
			$fsocket = @fsockopen("121.254.253.173", 3453, $errno, $errstr, 30);
			if (!$fsocket) { echo $errstr." (".$errno.")"; return false; }
		}

		fputs($fsocket, "A".$this->smsi_id.$this->smsi_pw);
		$gets = "";
		while(!$gets) $gets = trim(fgets($fsocket,21));

		if ($gets != 'Auth') { echo "ERROR : 서버 로그인 실패하였습니다."; return false; }

		set_time_limit(300);

		$gets = "";
		foreach($this->Data as $puts) {
			$toPhone = trim(substr($puts,1,11));
			if (substr($toPhone, 0, 2) == '50') $toPhone = "0".$toPhone;
			fputs($fsocket, $puts);
			while(!$gets) $gets = trim(fgets($fsocket,21));
			$this->Result[] = $toPhone." : ".$gets;
			$this->Log[] = $puts;
			$gets = "";
		}

		fclose($fsocket);
		$this->Data = "";
		return true;
	}

	function Init() {
		$this->Data = "";
		$this->Result = "";
	}

}

//  문자 공백체우기
function AddSpace($text,$size) {
	for ($i=0; $i<$size; $i++) $text .= " ";
	$text = substr($text,0,$size);
	return $text;
}

// 문자길이 조정
function CutChar($word, $cut) {
	$word = substr($word,0,$cut);						// 필요한 길이만큼 취함.
	for ($k = $cut-1; $k>1; $k--) {
		if (ord(substr($word,$k,1))<128) break;		// 한글값은 160 이상.
	}
	$word = substr($word,0,$cut-($cut-$k+1)%2);
	return $word;
}

// 수신번호 확인
function CheckPhone($strToCall, $CallCount) {
	for ($i=0; $i<$CallCount; $i++) {
		$strToCall[$i] = preg_replace("/[^0-9]/i","",$strToCall[$i]);
		$HP = substr($strToCall[$i],0,3);
		if ( preg_match("/[^0-9]/i", $HP) || ($HP != '010' && $HP != '011' && $HP != '016' && $HP != '017' && $HP != '018' && $HP != '019' && $HP != '050' && $HP != '070') || strlen($strToCall[$i]) < 10 || strlen($strToCall[$i]) > 12) return "ERROR : 휴대폰 번호가 올바르지 않습니다.";
	}
}

// 회신번호 확인
function CheckCallBack($strCallBack) {
	if (strlen($strCallBack) < 8 || strlen($strCallBack) > 11 || preg_match("/[^0-9]/i", $strCallBack) || !$strCallBack) return "ERROR : 회신번호가 올바르지 않습니다.";
}

// 예약날짜 확인
function CheckReqDate($strDate) {
	if ($strDate) {
		if (!checkdate(substr($strDate,4,2),substr($strDate,6,2),substr($strDate,0,4))) return "ERROR : 예약날짜가 올바르지 않습니다.";
		if (substr($strDate,8,2) > 23 || substr($strDate,10,2) > 59) return "ERROR : 예약시간이 잘못되었습니다";
	}
}
?>